---
type: index
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
---

# 20.0.5 - Interaction Dynamics (index)

> Observational dynamics at interfaces and within loops; tie to anchors (ε, c, π/φ) and SVA (∇S, λV, ψA).

---

## Dynamics Framework

| Dynamic | Description | Key Diagnostic |
|---------|-------------|----------------|
| [[Resonance (dynamic)]] | Phase alignment | Amplification control |
| [[Interference (dynamic)]] | Phase mixing | Pattern stability |
| [[Harmony (dynamic)]] | Component coherence | Flexible alignment |
| [[Dissonance (dynamic)]] | Phase tension | Productive conflict |

Each dynamic provides:
- Technical and humane diagnostic criteria
- Scale-dependent manifestations
- Phase behavior patterns
- Stability conditions

Note: Jamming/Saturation is covered under [[Saturated Field (classification)]].

---

## Core References

Primitives:
- [[Form]]
- [[Field]]
- [[Structure]]

Anchors:
- [[ε — Difference Resolution Quantum (constant)]]
- [[π — Closure Geometry Ratio (constant)]]
- [[e — Natural Transformation Rate (constant)]]
- [[φ — Asymmetric Stabilization Ratio (constant)]]
- [[c — Difference Propagation Limit (constant)]]

Modulators:
- [[∇S — Structure Differentiation Gradient (Sarkisian)]]
- [[λV — Void Resonance Threshold (Volozhina)]]
- [[ψA — Awareness Phase Coherence Anchor (Aiza)]]

Related Patterns:
- [[20.0.4 - Propagation Patterns (index)]]
- [[20.0.1 - Form Classifications (index)]]
- [[20.0.2 - Field Classifications (index)]]
- [[20.0.3 - Awareness Classifications (index)]]